#|______________________________________________________________________________
 |
 | plots001.lsp
 |
 | Contains the following constructor functions for the new ViSta Plots System:
 |
 |   dot-plot             1 dimensional point plot
 |   scatter-plot         2 dimensional point plot
 |   line-plot            2 dimensional connected point plot
 |   all-scatter-plots    all pairs of 2 dimensional point plots
 |   spinning-plot        3 dimensional spinnable point plot
 |   orbiting-points-plot h dimensional orbiting points plot
 |______________________________________________________________________________
 |#


(defun scatter-plot 
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) (connect nil)
             (location '(50 50)) (size '(320 320))
             (title "Scatter Plot") 
             (legend1 (send $ :name)) (legend2 nil) 
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types ))
         (data-object (when (= 4 (length graph-data)) (fourth graph-data)))
         (linkable t)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 title))
    (setf graph (send vista-scatterplot-proto :new  graph-data                        
                      :variable-labels variable-labels :point-labels point-labels
                      :connect connect
                      :show nil                        :top-most top-most
                      :container container             :pop-out pop-out
                      :location location               :size size 
                      :menu menu                       :title title 
                      :legend1 legend1                 :legend2 legend2
                      :go-away go-away                 :content-only content-only))
    
    (if actcon 
        (enable-container actcon)
        (disable-container))
    (when graph
          (send graph :legend1 
                (if data-object (send data-object :name)
                    "Unnamed Data"))
          (send graph :make-two-plot-menus
                "Scatter"
                :hotspot-items '(help dash new-x new-y dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          (send graph :title (strcat title " [" (send graph :legend1) "]"))
          (send graph :after-new-plot 
                pop-out top-most show size container linkable data-object)
          (when linkable (send graph :linked linked))
          )
    graph))




(defun dot-plot 
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) (connect nil)
             (location '(50 50)) (size '(320 320))
             (title "Dot Plot") 
             (legend1 (send $ :name)) (legend2 nil) 
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types ))
         (data-object (when (= 4 (length graph-data)) (fourth graph-data)))
         (linkable t)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    
    (unless legend2 (setf legend2 title))

    (setf graph (send vista-dotplot-proto :new graph-data 
                      :variable-labels variable-labels
                      :point-labels point-labels
                      :show show
                      :location location
                      :size size
                      :title title
                      :connect-points connect
                      :container container
                      :new-x t
                      :legend1 legend1
                      :legend2 legend2
                      :go-away go-away
                      :content-only content-only))
    
    (if actcon 
        (enable-container actcon)
        (disable-container))
    (when graph
          (send graph :legend1 
                (if data-object (send data-object :name)
                    "Unnamed Data"))
          (send graph :title (strcat title " [" (send graph :legend1) "]"))
          
          (send graph :after-new-plot 
                pop-out top-most show size container linkable data-object)
          (when linkable (send graph :linked linked))
          (send graph :make-two-plot-menus
                "DotPlot"
                :hotspot-items '(help dash new-x dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          )
    graph))





(defproto vista-dotplot-proto 
  '(spreadplot-supervisor showing legend1 legend2 legend3L legend3R container)
  '() scatterplot-proto)

(defmeth vista-dotplot-proto :isnew (&optional data 
        &key variable-labels point-labels connect-points
             (container nil) (show t) (top-most t) (pop-out nil)
             (location '(50 50)) (size '(300 300)) (new-x t)
             (title "Time Plot") 
             (legend1 (send $ :name)) (legend2 nil)
             (go-away t) (content-only nil)) 
  (let* (
         )
    (setf variable-labels (combine (first variable-labels) 
                                   "Observation Number" (rest variable-labels)))
    (setf data 
          (if (rest data)
              (append (append (list (first data))
                              (list (coerce (1+ (iseq (length (first data)))) 
                                            'vector)))
                      (rest data))
              (append (list (first data))
                      (list (coerce (1+ (iseq (length (first data))))
                                    'vector)))))
    (call-next-method (length data)
                      :variable-labels variable-labels
                      :point-labels point-labels
                      :show nil
                      :location location
                      :size size
                      :title title
                      )
    (send self :use-color t)
    (send self :add-points data)
    (when connect-points (send self :add-lines data :color 'blue))
    (send self :pop-out-on pop-out)
    (send self :top-most-on top-most)
    (send self :plot-buttons :new-x new-x :new-y nil :free nil :density nil)
    (send self :point-color (iseq (send self :num-points)) 'blue)
    (send self :mouse-mode 'brushing)
    (send self :x-axis t t (third (send self :x-axis)))
    (send self :y-axis t t (third (send self :y-axis)))
    (send self :point-label (iseq (send self :num-points)) point-labels)
    (send self :showing-labels t)
    (send self :legend1 legend1)
    (send self :legend2 legend2)
    (send self :adjust-to-data)
    (send self :container container)
    (when show (send self :show-window))
    (setf *graph* self)
    self))


(defmeth vista-dotplot-proto :legend1 (&optional (string nil set))
  (if set (setf (slot-value 'legend1) string))
  (slot-value 'legend1))

(defmeth vista-dotplot-proto :legend2 (&optional (string nil set))
  (if set (setf (slot-value 'legend2) string))
  (slot-value 'legend2))

(defmeth vista-dotplot-proto :legend3L (&optional (string nil set))
  (if set (setf (slot-value 'legend3L) string))
  (slot-value 'legend3L))

(defmeth vista-dotplot-proto :legend3R (&optional (string nil set))
  (if set (setf (slot-value 'legend3R) string))
  (slot-value 'legend3R))

(defmeth vista-dotplot-proto :container (&optional (object nil set))
  (if set (setf (slot-value 'container) object))
  (slot-value 'container))

(defmeth vista-dotplot-proto :redraw-content ()
  (call-next-method)
  (send self :draw-color 'black)
  (send self :draw-legends)
  (send self :add-grid))


(defun line-plot 
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) 
             (connect t) (connect-points t)
             (location '(50 50)) (size '(320 320))
             (title "Line Plot") 
             (legend1 (send $ :name)) (legend2 nil)
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types ))
         (data-object (when (= 4 (length graph-data)) (fourth graph-data)))
         (linkable t)
         (nice)
         (graph))
    (when (not (eql connect connect-points))
          (error-message "cannot use both connect and connect-points"))
    (unless variable-labels 
            (setf variable-labels (second graph-data)))
    (setf variable-labels (combine "Observation" variable-labels))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (setf graph-data 
          (append (list (coerce (1+ (iseq (length (first graph-data)))) 'vector)) 
                  graph-data))
    (setf nice (get-nice-range 0 (1+ (length (first graph-data))) 6))
    (unless legend2 (setf legend2 title))
    (setf graph (send vista-scatterplot-proto          :new  graph-data
                      :variable-labels variable-labels :point-labels point-labels
                      :connect-points connect-points   :lines nil
                      :new-x nil                       :new-y t
                      :show nil                        :top-most top-most
                      :container container             :pop-out pop-out
                      :location location               :size size 
                      :menu menu                       :title title 
                      :legend1 legend1                 :legend2 legend2
                      :go-away go-away                 :content-only content-only))
    (if actcon 
        (enable-container actcon)
        (disable-container))
    (send graph :range 0 (first nice) (second nice))
    (send graph :x-axis t t (third nice))
    (when graph
          (send graph :legend1 
                (if data-object (send data-object :name)
                    "Unnamed Data"))
          (send graph :title (strcat title " [" (send graph :legend1) "]"))
          (send graph :make-two-plot-menus
                "LinePlot"
                :hotspot-items '(help dash new-x new-y dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          (send graph :after-new-plot 
                pop-out top-most show size container linkable data-object)
          (when linkable (send graph :linked linked))
          )
    graph))


(defun scatter-matrix 
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) (connect nil)
             (location '(50 50)) (size '(320 320))
             (title "Scatter Matrix") 
             (legend1 (send $ :name)) (legend2 nil)
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types ))
         (data-object (when (= 4 (length graph-data)) (fourth graph-data)))
         (linkable t)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 title))
    (setf graph 
          (scatmat graph-data                        
                              :variable-labels variable-labels 
                              :point-labels point-labels
                              :show nil                        
                              :top-most top-most
                              :container container           
                              :pop-out pop-out
                              :location location 
                              :size size 
                              :menu nil
                              :title title 
                              :legend1 legend1  
                              :legend2 legend2
                              :go-away go-away       
                              :content-only content-only))
    
    (if actcon 
        (enable-container actcon)
        (disable-container))
    (when graph
          (send graph :title (strcat title 
                                     " [" 
                                     (if data-object (send data-object :name)
                                         "Unnamed Data")
                                     "]"))
          (send graph :point-color (iseq (send graph :num-points)) 'blue)
          (send graph :make-two-plot-menus
                "AllScat"
                :hotspot-items '(help dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          (send graph :after-new-plot 
                pop-out top-most show size container linkable data-object)
          (when linkable (send graph :linked linked))
          )
    graph))



(defun spinning-plot 
  (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) (connect nil)
             (location '(50 50)) (size '(320 320))
             (title "Spinning Plot") 
             (legend1 (send $ :name)) (legend2 nil)
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types))
         (data-object (when (= 4 (length graph-data)) (fourth graph-data)))
         (linkable t)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 title))
    (setf graph (send vista-spinplot-proto :new  graph-data                        
                      :variable-labels variable-labels :point-labels point-labels
                      :show nil                        :top-most top-most
                      :container container             :pop-out pop-out
                      :actcon actcon
                      :location location               :size size 
                      :menu menu                       :title title 
                      :legend1 legend1                 :legend2 legend2
                      :go-away go-away                 :content-only content-only))
    (when graph
          (send graph :title (strcat 
             title " [" (if data-object (send data-object :name) "Unnamed Data") "]"))
          (send graph :make-two-plot-menus
                "SpinPlot"
                :hotspot-items '(help dash new-x new-y new-z dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          (send graph :after-new-plot 
                pop-out top-most show size container linkable data-object)
          (when linkable (send graph :linked linked))
          (send graph :scaled-range 
                (iseq (send graph :num-variables)) -2 2))
    graph))


(defun orbiting-plot
   (&optional data &key (ok-var-types '(numeric)) 
             variable-labels point-labels 
             (show t) (top-most t) (linked t) (connect nil)
             (location '(50 50)) (size '(320 320))
             (title "Orbiting Plot") 
             (legend1 (send $ :name)) (legend2 nil)
             ;dont use menu-item and menu 
             ;following dont work
             (content-only nil)  (go-away t)
             ;do not use menu-item, menu, in, in?, in??, or in???
             ;all are reserved for system use 
             (menu-item nil) (menu t)
             (in nil in??) (in? nil in???))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-plot data ok-var-types ))
         (data-object (when (= 4 (length graph-data)) (fourth graph-data)))
         (linkable t)
         (graph))
    (unless variable-labels (setf variable-labels (second graph-data)))
    (unless point-labels (setf point-labels (third graph-data)))
    (setf graph-data (first graph-data))
    (unless legend2 (setf legend2 title))
    (setf graph 
          (tourplot graph-data                        
                    :variable-labels variable-labels 
                    :point-labels point-labels
                    :title title 
                    :location location 
                    :size size
                    :show nil))
    (when graph 
          (send graph :initial-tour))
    (if actcon 
        (enable-container actcon)
        (disable-container))
    (when graph
          (send graph :title (strcat 
             title " [" (if data-object (send data-object :name) "Unnamed Data") "]"))
          (send graph :point-color (iseq (send graph :num-points)) 'blue)
          (send graph :point-label (iseq (send graph :num-points)) point-labels)
          
          (send graph :make-two-plot-menus
                "OrbitPlot"
                :hotspot-items '(help dash link dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(showing-labels mouse resize-brush dash 
                                 select-all show-all dash 
                                 erase-selection focus-on-selection view-selection dash
                                 color symbol dash selection slicer))
          (send graph :after-new-plot pop-out top-most show size container 
                linkable data-object)
          (when linkable (send graph :linked linked))
          )
    graph))

